/*
*******************************************************************************
*
* File:         pxriblk.h
* Description:  
* Author:       Henrik Liebau
* Created:      05 Apr 2000, 09:24:05
* Modified:     Tue May 29 17:08:15 2001 by Henrik Liebau, BVS R&D
* Language:     C/C++ Include File
* Package:	PCI-X Protocol Permutator&Randomizer      
* Status:       
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __pxriblk_H__
#define __pxriblk_H__

/* include type definitions, if not already done */
#ifndef __pxdef_H__
#include <pxdef.h>
#endif /* defined __pxdef_H__ */

/* include type definitions, if not already done */
#ifndef __pxblkdef_H__
#include <pxblkdef.h>
#endif /* defined __pxblkdef_H__ */

/* make sure this also runs in C++ programs */
#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 * public, exported functions
 *****************************************************************************/
/*----------------------------------------------------------------------------*
 * BestXPprRIBlkPermDefaultSet 
 * CLI abbrev.: pprriblkpermdefaultset
 *
 * Set PPR Ri Block perm settings to defaults 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBlkPermDefaultSet (   /* @pprriblkpermdefaultset */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBlkPermSet 
 * CLI abbrev.: pprriblkpermset prop=<permprop> value = <value>
 *
 * Set / Get PPR Block requester initiator settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBlkPermSet (	      /* @pprriblkpermset */
  bx_handletype handle,
  bxppr_riblkpermtype permprop,			      /* @prop */
  bx_int32 value				      /* @val */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBlkPermGet 
 * CLI abbrev.: pprriblkpermget prop=<permprop> value = <value>
 *
 * Get / Get PPR Block requester initiator settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBlkPermGet (	      /* @pprriblkpermget */
  bx_handletype handle,
  bxppr_riblkpermtype permprop,			      /* @prop */
  bx_int32 * pValue				      /* #RETURN "%08lx\\h" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBlkListDefaultSet 
 * CLI abbrev.: pprriblklistdefaultset prop = <blkprop>
 *
 * set variation list for requester initiator blk props to default 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBlkListDefaultSet (   /* @pprriblklistdefaultset */
  bx_handletype handle,
  bxppr_riblktype blkprop			      /* @prop */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBlkListSet/ 
 * CLI abbrev.: pprriblklistset prop = <blkprop> list = <list>
 *
 * set / get variation list for requester initiator blkprops 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBlkListSet (	      /* @pprriblklistset */
  bx_handletype handle,
  bxppr_riblktype blkprop,			      /* @prop */
  bxppr_listtype  list				      /* @list */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBlkListGet/ 
 * CLI abbrev.: pprriblklistget prop = <blkprop> list = <list>
 *
 * get / get variation list for requester initiator blkprops 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBlkListGet (	      /* @pprriblklistget */
  bx_handletype handle,
  bxppr_riblktype blkprop,			      /* @prop */
  bxppr_listtype * pList			      /* #RETURN "%s" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBlkResultGet 
 * CLI abbrev.: pprriblkresultget prop = <resultprop>
 *
 * get permutation result for selected result prop 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBlkResultGet (	      /* @pprriblkresultget */
  bx_handletype handle,
  bxppr_riblkresulttype resultprop,		      /* @prop */
  bx_int32 * pValue				      /* #RETURN "%08lx\\h" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBlkGapGet 
 * CLI abbrev.: pprriblkgapget gap = <gapnum> type = <gapprop>
 *
 * get gap property for selected gap. See Fill Gaps in ERS 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBlkGapGet (	      /* @pprriblkgapget */
  bx_handletype handle,
  bx_int32 gapnum,				      /* @gap */
  bxppr_riblkgaptype gapprop,			      /* @prop */
  bx_int32 * pValue				      /* #RETURN "%08lx\\h" */
  );

/*****************************************************************************
 * functions used internally
 *****************************************************************************/

#ifdef PPRX_EXPORTS

/*---------------------------------------------------------------------------*
 * bx_errtype PprBlkReportGet ( bxppr_stringtype * reportStr,
 *
 * Purpose	: print block specific info into report
 *---------------------------------------------------------------------------*/
bx_errtype PprBlkReportGet (
  bxppr_stringtype * reportStr,
  bxppr_vardatatype * varData,
  bxppr_blkresultdatatype * blkResult,
  bx_int32 contents,
  bx_int32 capi
  );
  
/*---------------------------------------------------------------------------*
 * bx_errtype PprBlkGenerate (
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprBlkGenerate (
  bxppr_datatype * pprData,
  bx_int32 algorithm,
  bx_int32 * randomSeed,
  bxppr_vardatatype * varData,
  bxppr_blkresultdatatype * blkResult
  );

/*---------------------------------------------------------------------------*
 * bx_errtype PprBlkProg ( bx_handletype handle,
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprBlkProg ( bx_handletype handle,
			bxppr_vardatatype * varData,
			bxppr_blkresultdatatype * blkResult );

#endif /* defined PPRX_EXPORTS */
  
#ifdef __cplusplus
}
#endif

#endif /* defined __pxriblk_H__ */
